unit WebUserControl8;

//agprefix="owe" Tagname="edit"

interface

uses DateUtils, SysUtils, System.Web.Security, System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
    /// <summary>
    ///		Summary description for WebUserControl8.
    /// </summary>
  TWebUserControl8 = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
		procedure btnAddProduct_Click(sender: System.Object; e: System.EventArgs);
		procedure btnLogout_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		MyError: System.Web.UI.WebControls.Label;
		btnLogout: System.Web.UI.WebControls.LinkButton;
		devName: System.Web.UI.WebControls.Literal;
		devAddress: System.Web.UI.WebControls.Literal;
		devTel: System.Web.UI.WebControls.Literal;
		devFax: System.Web.UI.WebControls.Literal;
		devContact: System.Web.UI.WebControls.Literal;
		devWebSite: System.Web.UI.WebControls.Literal;
		devEmail: System.Web.UI.WebControls.Literal;
		devpassword: System.Web.UI.WebControls.Literal;
		RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
		txtProductName: System.Web.UI.WebControls.TextBox;
		cboAppType: System.Web.UI.WebControls.ListBox;
		cboAppPayType: System.Web.UI.WebControls.ListBox;
		txtDescription: System.Web.UI.WebControls.TextBox;
		txtSearchWords: System.Web.UI.WebControls.TextBox;
		UploadHolder: System.Web.UI.WebControls.PlaceHolder;
		btnAddProduct: System.Web.UI.WebControls.Button;
		dgEditProductsHolder: System.Web.UI.WebControls.PlaceHolder;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
    procedure OnInit(e: System.EventArgs); override;
  end;

implementation


uses productsdb, developersDB, appTypesDB, productsgrid, htmlinputfile;


var
  DeveloperID : integer;
  dg : TProductsGrid;
  txtImageFile : THtmlInputFile;

procedure TWebUserControl8.Page_Load(sender: System.Object; e: System.EventArgs);
var
  dev : TdevelopersDB;
  devdetails : DeveloperDetails;
  apptypes : TAppTypesDB;
  context : HttpContext;
begin
    context := HttpContext.Current;
    try
      DeveloperID := StrToInt(context.User.Identity.Name);
    except
      DeveloperID := 0;
    end;
//MyError.Text:=User.Identity.Name;
    dg.DeveloperID:=DeveloperID;

    if not IsPostBack then
    begin
      try
        // begin fill dev details
        dev := TdevelopersDB.Create;
        devdetails := DeveloperDetails.Create;

        devdetails:= dev.GetDeveloperDetails(DeveloperID);

        devName.Text := devdetails.Name;
        devAddress.Text := devdetails.Address;
        devTel.Text := devdetails.Tel;
        devFax.Text := devdetails.Fax;
        devContact.Text := devdetails.Contact;
        devWebSite.Text := devdetails.WebSite;
        devEmail.Text := devdetails.Email;
        devpassword.Text := '***';//devdetails.password;

        dev.Free;
        devdetails.Free;
        // end fill dev


        topicHeading.Text:=' &#187;' + devName.Text ;
        topicDescription.Text:='Manage your submissions';

        dg.DoDataBind;

        //begin bind AppTypes; apppaytypes
        apptypes := TAppTypesDB.Create;
        cboAppType.DataSource := apptypes.GetALLProductCategories;
        cboAppType.DataTextField:='name';
        cboAppType.DataValueField:='name';
        cboAppType.DataBind;


        cboAppPayType.DataSource := apptypes.GetAppPayTypes;
        cboAppPayType.DataTextField:='name';
        cboAppPayType.DataValueField:='name';
        cboAppPayType.DataBind;

        apptypes.Free;
        //end bind AppTypes; apppaytypes
      except
        on e:Exception do
        begin
          topicHeading.Text:='Error: ' + e.message;
        end;
      end;
    end; // ispostback
end;

procedure TWebUserControl8.OnInit(e: System.EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

 		txtImageFile:=THtmlInputFile.create;
		//txtImageFile.Accept:='image/*';
		txtImageFile.ServerFolder :='C:\Inetpub\wwwroot\OctaneWebExample\ExamplesGFX';
		txtImageFile.ImageFolder:='ExamplesGFX';
		txtImageFile.Style.Add('font-family', 'Verdana, Helvetica, sans-serif');
		txtImageFile.Style.Add('border-style','solid');
		txtImageFile.Style.Add('border-width','1px');
		txtImageFile.Style.Add('width','90%');
		UploadHolder.Controls.Add(txtImageFile);
    txtImageFile.Free;

		dg:=TProductsGrid.Create;
		dg.DeveloperName:=devName.Text;
		dg.ErrorLabel:=MyError;
    dgEditProductsHolder.Controls.Add(dg);
    dg.Free;
end;

procedure TWebUserControl8.btnLogout_Click(sender: System.Object; e: System.EventArgs);
var
  cok :HTTPCookie;
begin
    FormsAuthentication.SignOut;

		cok:=HTTPCookie.Create('owe_name');
    try
		  cok.value:='';
		  cok.Expires := DateTime.FromOADate(IncMonth(Date,-12));
		  Response.Cookies.Add(cok);
    finally
      cok.Free;
    end;

		Response.Redirect('webform1.aspx');
end;

procedure TWebUserControl8.btnAddProduct_Click(sender: System.Object; e: System.EventArgs);
var
    prds : TproductsDB;
    ProductID : integer;
    ImageFullName, sProdDesc: string;
begin
    prds:=TproductsDB.Create;

    ImageFullName:='';


    if txtImageFile.UploadFile(ImageFullName) then
    begin // image upload ok
      sProdDesc := StringReplace(txtDescription.Text, #13#10 , '<br>', [rfReplaceAll]);
      ProductID := prds.AddProduct(DeveloperID,	devName.Text,	txtProductName.Text, cboAppType.SelectedItem.Text, cboAppPayType.SelectedItem.Text,	sProdDesc, txtSearchWords.Text,	ImageFullName);

      prds.Free;
    end
    else // upload failed
    begin
      MyError.Text := txtImageFile.ErrorMSG;
      ProductID:=0;
    end; //if upload

    if ProductID <> 0 then
    begin
      txtProductName.Text:='';
      cboAppType.SelectedIndex:=0;
      cboAppPayType.SelectedIndex:=0;
      txtDescription.Text:='';
      txtSearchWords.Text:='';

      dg.DoDataBind;
      MyError.Text := 'Your example was successfully submitted!';
    end;
end; //procedure btnAddProduct_Click

{$REGION 'Designer Managed Code'}
///		Required method for Designer support - do not modify
///		the contents of this method with the code editor.
/// </summary>
procedure TWebUserControl8.InitializeComponent;
begin
	Include(Self.btnLogout.Click, Self.btnLogout_Click);
	Include(Self.btnAddProduct.Click, Self.btnAddProduct_Click);
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.
